# Function:
# This script is used to run a EPMeta search by combining the results 
# from DiscoTope, BEpro, Epitopia, Sepea, EPCES, and EPSVR

# Warning: this script must be run on Linux operating system
# Warning: please be sure that meta.out and pdb_fasta.pl are located in the same filefold of this scrpit

# Before run this script, six results need to be obtained. Please get the six search results from 
# the six servers below by your protein PDB file or PDB ID.
# 1) BEPro server: http://pepito.proteomics.ics.uci.edu/
# The result file is named by BEPro.pdb

# 2) DiscoTope server: http://www.cbs.dtu.dk/services/DiscoTope/
# The result file is named by DiscoTope.pdb

# 3) Epitopia server: http://epitopia.tau.ac.il/
# The result file is named by Epitopia.pdb

# 4) Sepea server: http://lifecenter.sgst.cn/seppa/
# The result file is named by Sepea.pdb

# 5) EPCES server: http://sysbio.unl.edu/EPCES/
# The result file is named by EPCES.pdb

# 6) EPSVR: http://sysbio.unl.edu/EPSVR/
# The result file is named by EPSVR.pdb

# if anyone of six results above can not be obtained from its relevant server, just skip it.
# Meta.out may ignore this result if can not fine it.

# when the prediction files are ready, please copy these files into the same filefold of this script
# run this script on Linux operating system to the EPMeta result, i.e., EPMeta_output.pdb and EPMeta.html.

# Date: 07/29/2013


#!/bin/bash

# Generate meta result from six predictions and put into EPMeta_output.pdb
./meta.out "EPSVR.pdb" "EPCES.pdb" "EPITOPIA.pdb" "SEPPA.pdb" "BEPRO.pdb" "DISCOITOPE.pdb" "EPMeta"


#generate HTML file to illustrate the meta result
	
#generate _tmp.html which contains graphic structure of output pdb file
perl pdb_fasta.pl "EPMeta_output.pdb" > _tmp.html

outhtml="EPMeta.html"
rm -if $outhtml
echo "<HTML><HEAD> <TITLE>  EPMeta output </TITLE> </HEAD>" >> $outhtml
echo "<BODY> " >> $outhtml
echo "<H1> EPMeta RESULT FOR ${jobname} </H1> " >> $outhtml
echo "<PRE> " >> $outhtml
echo "-------------------------------------------------------------- " >> $outhtml
echo "Your job ID:${jobname} " >> $outhtml
echo "--------------------------------------------------------------" >> $outhtml
echo "The following are predicted antigenic epitope:" >>  $outhtml
echo "</pre>" >> $outhtml
cat _tmp.html >> $outhtml
echo "<P> " >> $outhtml
echo "<PRE> " >> $outhtml
echo "</BODY>" >> $outhtml
echo "</HTML>" >> $outhtml

# delete temperory html file
rm -rf _tmp.html


